﻿using HISoftware.Webdispecink.Api;
using HISoftware.Webdispecink.Api.Types;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace ConsoleApp2
{
    class Program
    {
        static void Main(string[] args)
        {
            WebdispecinkClientProxy proxy = new WebdispecinkClientProxy
            {
                Company = "xxxxx",       // <---- Write your company code
                Username = "xxxxx",      // <---- Write your username
                Password = "xxxxx"       // <---- Write your password
            };

            try
            {
                // Calling GetCarsList API
                Task<IEnumerable<WDS_CarItem>> taskGetCarList = proxy.GetCarsListAsync();

                WDS_CarItem[] listCars = taskGetCarList.Result.ToArray();

                Console.WriteLine($"All cars from \"{proxy.Company}\" company:");
                Console.WriteLine("-------------------------------------");

                foreach (WDS_CarItem carItem in listCars)
                {
                    Console.WriteLine($"License plate: {carItem.identifikator}, Car Id: {carItem.carid}");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Exception {ex.GetType().FullName} has been thrown!\nMessage: \"{ex.InnerException.Message}\"");
            }

            Console.ReadLine();
        }
    }
}
